/*
 * Decompiled with CFR 0.152.
 */
package com.mrh0.createaddition.rendering;

import com.mrh0.createaddition.energy.IWireNode;
import com.mrh0.createaddition.energy.WireType;
import com.mrh0.createaddition.rendering.CARenderType;
import net.minecraft.class_1159;
import net.minecraft.class_1944;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2586;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_5614;
import net.minecraft.class_765;
import net.minecraft.class_827;

public class WireNodeRenderer<T extends class_2586>
implements class_827<T> {
    private static final float HANG = 0.5f;

    public WireNodeRenderer(class_5614.class_5615 context) {
    }

    public void method_3569(T tileEntityIn, float partialTicks, class_4587 matrixStackIn, class_4597 bufferIn, int combinedLightIn, int combindOverlayIn) {
        IWireNode te = (IWireNode)tileEntityIn;
        for (int i = 0; i < te.getNodeCount(); ++i) {
            if (te.getNodeType(i) == null) continue;
            class_243 d1 = te.getNodeOffset(i);
            float ox1 = (float)d1.method_10216();
            float oy1 = (float)d1.method_10214();
            float oz1 = (float)d1.method_10215();
            IWireNode wn = te.getNode(i);
            if (wn == null) {
                return;
            }
            class_243 d2 = wn.getNodeOffset(te.getOtherNodeIndex(i));
            float ox2 = (float)d2.method_10216();
            float oy2 = (float)d2.method_10214();
            float oz2 = (float)d2.method_10215();
            class_2338 other = te.getNodePos(i);
            float tx = other.method_10263() - te.getMyPos().method_10263();
            float ty = other.method_10264() - te.getMyPos().method_10264();
            float tz = other.method_10260() - te.getMyPos().method_10260();
            matrixStackIn.method_22903();
            float dis = WireNodeRenderer.distanceFromZero(tx, ty, tz);
            matrixStackIn.method_22904((double)(tx + 0.5f + ox2), (double)(ty + 0.5f + oy2), (double)(tz + 0.5f + oz2));
            WireNodeRenderer.wireRender(tileEntityIn, other, matrixStackIn, bufferIn, -tx - ox2 + ox1, -ty - oy2 + oy1, -tz - oz2 + oz1, te.getNodeType(i), dis);
            matrixStackIn.method_22909();
        }
    }

    private static float divf(int a, int b) {
        return (float)a / (float)b;
    }

    private static float hang(float f, float dis) {
        return (float)Math.sin(-f * (float)Math.PI) * (0.5f * dis / (float)IWireNode.MAX_LENGTH);
    }

    public static float distanceFromZero(float x, float y, float z) {
        return (float)Math.sqrt(Math.pow(x, 2.0) + Math.pow(y, 2.0) + Math.pow(z, 2.0));
    }

    public static void wireRender(class_2586 tileEntityIn, class_2338 other, class_4587 matrix, class_4597 buffer, float x, float y, float z, WireType type, float dis) {
        class_4588 ivertexbuilder = buffer.getBuffer(CARenderType.WIRE);
        class_1159 matrix4f = matrix.method_23760().method_23761();
        float f = class_3532.method_22858((float)(x * x + z * z)) * 0.025f / 2.0f;
        float o1 = z * f;
        float o2 = x * f;
        class_2338 blockpos1 = tileEntityIn.method_11016();
        class_2338 blockpos2 = other;
        int i = tileEntityIn.method_10997().method_8314(class_1944.field_9282, blockpos1);
        int j = tileEntityIn.method_10997().method_8314(class_1944.field_9282, blockpos2);
        int k = tileEntityIn.method_10997().method_8314(class_1944.field_9284, blockpos1);
        int l = tileEntityIn.method_10997().method_8314(class_1944.field_9284, blockpos2);
        WireNodeRenderer.wirePart(ivertexbuilder, matrix4f, x, y, z, j, i, l, k, 0.025f, 0.025f, o1, o2, type, dis);
        WireNodeRenderer.wirePart(ivertexbuilder, matrix4f, x, y, z, j, i, l, k, 0.025f, 0.0f, o1, o2, type, dis);
    }

    public static void wirePart(class_4588 vertBuilder, class_1159 matrix, float x, float y, float z, int l1, int l2, int l3, int l4, float a, float b, float o1, float o2, WireType type, float dis) {
        for (int j = 0; j < 24; ++j) {
            float f = (float)j / 23.0f;
            int k = (int)class_3532.method_16439((float)f, (float)l1, (float)l2);
            int l = (int)class_3532.method_16439((float)f, (float)l3, (float)l4);
            int light = class_765.method_23687((int)k, (int)l);
            WireNodeRenderer.wireVert(vertBuilder, matrix, light, x, y, z, a, b, 24, j, false, o1, o2, type, dis);
            WireNodeRenderer.wireVert(vertBuilder, matrix, light, x, y, z, a, b, 24, j + 1, true, o1, o2, type, dis);
        }
    }

    public static void wireVert(class_4588 vertBuilder, class_1159 matrix, int light, float x, float y, float z, float a, float b, int count, int index, boolean sw, float o1, float o2, WireType type, float dis) {
        int cr = type.getRed();
        int cg = type.getGreen();
        int cb = type.getBlue();
        if (index % 2 == 0) {
            cr = (int)((float)cr * 0.7f);
            cg = (int)((float)cg * 0.7f);
            cb = (int)((float)cb * 0.7f);
        }
        float part = (float)index / (float)count;
        float fx = x * part;
        float fy = (y > 0.0f ? y * part * part : y - y * (1.0f - part) * (1.0f - part)) + WireNodeRenderer.hang(WireNodeRenderer.divf(index, count), dis);
        float fz = z * part;
        if (Math.abs(x) + Math.abs(z) < Math.abs(y)) {
            boolean p = b > 0.0f;
            float c = 0.015f;
            if (!sw) {
                vertBuilder.method_22918(matrix, fx - c, fy, fz + (p ? -c : c)).method_1336(cr, cg, cb, 255).method_22916(light).method_1344();
            }
            vertBuilder.method_22918(matrix, fx + c, fy, fz + (p ? c : -c)).method_1336(cr, cg, cb, 255).method_22916(light).method_1344();
            if (sw) {
                vertBuilder.method_22918(matrix, fx - c, fy, fz + (p ? -c : c)).method_1336(cr, cg, cb, 255).method_22916(light).method_1344();
            }
        } else {
            if (!sw) {
                vertBuilder.method_22918(matrix, fx + o1, fy + a - b, fz - o2).method_1336(cr, cg, cb, 255).method_22916(light).method_1344();
            }
            vertBuilder.method_22918(matrix, fx - o1, fy + b, fz + o2).method_1336(cr, cg, cb, 255).method_22916(light).method_1344();
            if (sw) {
                vertBuilder.method_22918(matrix, fx + o1, fy + a - b, fz - o2).method_1336(cr, cg, cb, 255).method_22916(light).method_1344();
            }
        }
    }
}

